<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */

class MinervaKB_GlossaryShortcode extends KST_Shortcode implements KST_Shortcode_Interface {

	protected $ID = 'glossary';
	protected $name = 'Glossary';
	protected $description = 'List of glossary entries';
	protected $icon = 'fa fa-comment-o';

	public function render($atts, $content = '') {
        $query_args = array(
            'post_type' => 'mkb_glossary',
            'ignore_sticky_posts' => 1,
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'ASC'
        );

        $topic_loop = new WP_Query( $query_args );
        $glossary_list = array();
        $current_letter = null;

        if ($topic_loop->have_posts()):
            while ( $topic_loop->have_posts() ) : $topic_loop->the_post();

                $title = get_the_title();
                $first_letter = mb_substr($title, 0, 1);
                $first_letter = function_exists('mb_strtolower') ? mb_strtolower($first_letter) : strtolower($first_letter);

                if ($first_letter !== $current_letter) {
                    $current_letter = $first_letter;

                    $glossary_list[$current_letter] = array();
                }

                array_push($glossary_list[$current_letter], get_the_ID());
            endwhile;
        endif;

        wp_reset_postdata();

        if (!sizeof($glossary_list)) {
            return;
        }

        ?>
        <div class="mkb-glossary-list-wrapper js-mkb-glossary-list">
            <ul id="mkb_glossary_toc" class="js-mkb-glossary-list-toc mkb-glossary-list-toc"><?php
                foreach ($glossary_list as $letter => $entries):
                    $uppercase_letter = function_exists('mb_strtoupper') ? mb_strtoupper($letter) : strtoupper($letter);
                ?><li>
                    <a href="#mkb_glossary_letter_<?php echo esc_attr($letter); ?>"><?php echo esc_html($uppercase_letter); ?></a>
                </li><?php
                endforeach; ?>
            </ul><!--.mkb-glossary-list-toc-->
            <div class="mkb-glossary-list">
            <?php

            // glossary list

            $layout = MKB_Options::option('glossary_list_layout');

            foreach ($glossary_list as $letter => $letter_group):
                $uppercase_letter = function_exists('mb_strtoupper') ? mb_strtoupper($letter) : strtoupper($letter);
                ?>
                <div class="mkb-glossary-letter-group">
                    <h2 id="mkb_glossary_letter_<?php echo esc_attr($letter); ?>"><?php echo esc_html($uppercase_letter); ?></h2><?php
                    foreach ($letter_group as $id): ?>
                        <div class="js-mkb-glossary-term-entry mkb-glossary-term-entry"
                             id="mkb_glossary_term_<?php echo esc_attr($id); ?>"
                             data-id="<?php echo esc_attr($id); ?>">

                            <h3>
                                <?php if ($layout === 'links'): ?><a href="<?php echo esc_attr(get_the_permalink($id))?>"><?php endif; ?>
                                <?php echo esc_html(get_the_title($id)); ?>
                                <?php if ($layout === 'links'): ?></a><?php endif; ?>
                            </h3>

                            <div class="mkb-glossary-term-entry-content">
                                <?php if ($layout === 'full'): ?>
                                    <?php echo apply_filters('the_content', get_post_field('post_content', $id)); ?>
                                <?php elseif ($layout === 'excerpt'):
                                    $excerpt_length = (int) MKB_Options::option('glossary_excerpt_length');
                                    $plain_content = strip_tags(has_excerpt($id) ?
                                        get_the_excerpt($id) :
                                        apply_filters('the_content', get_post_field('post_content', $id))
                                    );
                                    $plain_content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $plain_content);
                                    $is_not_full_content = $excerpt_length < strlen($plain_content);
                                    $postfix = $is_not_full_content ? '...' : '';

                                    // trim excerpt to desired length
                                    $content = mb_substr($plain_content, 0, $excerpt_length) . $postfix;

                                    ?>
                                    <?php echo wp_kses_post($content); ?>
                                    <?php if ($is_not_full_content): ?>
                                        <a href="<?php echo esc_attr(get_the_permalink($id))?>"><?php echo esc_html(MKB_Options::option('glossary_list_read_more')); ?></a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>

                            <?php if ($layout === 'full'): ?>
                                <a href="#mkb_glossary_toc"><?php echo esc_html(MKB_Options::option('glossary_back_to_top')); ?></a>
                            <?php endif; ?>
                        </div>
                    <?php
                    endforeach; ?>
                    <?php if ($layout !== 'full'): ?>
                        <a href="#mkb_glossary_toc"><?php echo esc_html(MKB_Options::option('glossary_back_to_top')); ?></a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>

            </div><!--.mkb-glossary-list-->
        </div><!--.mkb-glossary-list-wrapper-->
        <?php
	}
}